{include file="header_dash.tpl" meta_title="Account Dashboard | {$settings.site_name}"}

 <!-- TradingView Widget BEGIN -->
        <div class="tradingview-widget-container">
            <div class="tradingview-widget-container__widget"></div>

            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                {
                    "symbols": [{
                            "proName": "FOREXCOM:SPXUSD",
                            "title": "S&P 500"
                        },
                        {
                            "proName": "FOREXCOM:NSXUSD",
                            "title": "US 100"
                        },
                        {
                            "proName": "FX_IDC:EURUSD",
                            "title": "EUR/USD"
                        },
                        {
                            "proName": "BITSTAMP:BTCUSD",
                            "title": "BTC/USD"
                        },
                        {
                            "proName": "BITSTAMP:ETHUSD",
                            "title": "ETH/USD"
                        },
                        {
                            "description": "TRX/USD",
                            "proName": "BINANCE:TRXUSDT"
                        },
                        {
                            "description": "DOGE/USD",
                            "proName": "BITFINEX:DOGEUSD"
                        }
                    ],
                    "showSymbolLogo": true,
                    "colorTheme": "dark",
                    "isTransparent": false,
                    "displayMode": "adaptive",
                    "locale": "en"
                }

            </script>
        </div>
        <!-- TradingView Widget END -->

        <div class="container-fluid mb-5">
            <!-- Title -->
            <h1 class="h2">
                Welcome, {$userinfo.name|escape:"quotes"}!
            </h1>
            <div>
            </div>
            <div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="py-4 alert alert-primary alert-dismissible fade show" role="alert">
                        Welcome to {$settings.site_name}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3">
                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div >
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-primary" ></span>
                                            Total Balance
                                        </h5>

                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            {$currency_sign}{$ab_formated.total}
                                        </h2>

                                        <a href="?a=add_funds" class="fs-6 btn-link mb-0 mt-2 mr-3" style="color:#fff">
                                            Deposit
                                        </a>
                                     
                                    </div>

                                    <span class="text-primary">
                                        <i style="color:black" class="bi bi-wallet-fill fs-1"></i>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                
                
                <div class="col-lg-3">
                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div>
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-success"></span>
                                            Total Deposited
                                        </h5>
                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            {$currency_sign}{$ab_formated.deposit}
                                        </h2>
                                        <!-- Comment -->
                                        <a href="?a=deposit_history">
                                            <p style="color:#fff" class="fs-6 btn-link mb-0 mt-2">
                                                View deposits
                                            </p>
                                        </a>
                                    </div>

                                    <span class="text-success">
                                        <i class="bi bi-box-arrow-in-down fs-1"></i>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                
                
                <div class="col-lg-3">
                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div>
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-danger"></span>
                                            Total Withdrawal
                                        </h5>
                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            {$currency_sign}{$ab_formated.withdrawal}
                                        </h2>
                                        <!-- Comment -->
                                        <a href="?a=withdraw_history">
                                            <p  style="color:#fff" class="fs-6 btn-link mb-0 mt-2">
                                                View withdrawals
                                            </p>
                                        </a>
                                    </div>

                                    <span class="text-danger">
                                        <i class="bi bi-box-arrow-in-up fs-1"></i>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3">
                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div>
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-success"></span>
                                            Total Profit
                                        </h5>
                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            {$currency_sign}{$ab_formated.earning}
                                        </h2>
                                        <!-- Comment -->
                                        <a href="?a=earnings">
                                            <p  style="color:#fff" class="fs-6 btn-link mb-0 mt-2">
                                                View profit history
                                            </p>
                                        </a>
                                    </div>

                                    <span class="text-success">
                                        <i class="bi bi-coin fs-1"></i>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3">
                    <!-- Card -->
                    <div class="card border-0">
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div>
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-info"></span>
                                            Active Deposit
                                        </h5>
                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                            {$currency_sign}{$ab_formated.active_deposit}
                                        </h2>
                                        <!-- Comment -->
                                        <a href="?a=deposit_history">
                                            <p  style="color:#fff" class="fs-6 btn-link mb-0 mt-2">
                                                View bonus history
                                            </p>
                                        </a>
                                    </div>

                                    <span class="text-info">
                                        <i class="bi bi-gift-fill fs-1"  style="color:orange;"></i>
                                    </span>
                                </div>
                            </div> <!-- / .row -->
                        </div>
                    </div>
                </div>
                
                
                   <div class="col-lg-3">
                    <div class="card border-0">
                        <!-- Card body -->
                        <div class="card-body" style="background-color:#00bac7">
                            <div class="row">
                                <div class="col d-flex justify-content-between">
                                    <div>
                                        <!-- Title -->
                                        <h5 class="d-flex align-items-center text-uppercase text-muted fw-semibold mb-2">
                                            <span class="legend-circle-sm bg-secondary"></span>
                                           Referral Bouns
                                        </h5>
                                        <!-- Subtitle -->
                                        <h2 class="mb-0">
                                         {$currency_sign}{$ab_formated.commissions}
                                        </h2>
                                        <!-- Comment -->
                                        <a href="?a=referals" style="color:#fff" >
                                            <p class="fs-6 btn-link mb-0 mt-2">
                                                View referrals
                                            </p>
                                        </a>
                                    </div>
                                    <span class="text-secondary">
                                        <i style="color:blue;" class="bi bi-piggy-bank fs-1"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

              
            </div>

           

        </div>

{include file="footer_dash.tpl"}