{include file="header_dash.tpl" meta_title="Profile | {$settings.site_name}"}

<div class="container-fluid mb-5">
    <!-- Title -->
    <h1 class="h2">
        Account Settings
    </h1>
    
        


{literal}
<script language=javascript>
function IsNumeric(sText) {
  var ValidChars = "0123456789.";
  var IsNumber=true;
  var Char;
  if (sText == '') return false;
  for (i = 0; i < sText.length && IsNumber == true; i++) { 
    Char = sText.charAt(i); 
    if (ValidChars.indexOf(Char) == -1) {
      IsNumber = false;
    }
  }
  return IsNumber;
}

function checkform() {
  if (document.editform.fullname.value == '') {
    alert("Please type your full name!");
    document.editform.fullname.focus();
    return false;
  }
{/literal}
{if $settings.use_user_location == 1}
{literal}
  if (document.editform.address.value == '') {
    alert("Please enter your address!");
    document.editform.address.focus();
    return false;
  }
  if (document.editform.city.value == '') {
    alert("Please enter your city!");
    document.editform.city.focus();
    return false;
  }
  if (document.editform.state.value == '') {
    alert("Please enter your state!");
    document.editform.state.focus();
    return false;
  }
  if (document.editform.zip.value == '') {
    alert("Please enter your ZIP!");
    document.editform.zip.focus();
    return false;
  }
  if (document.editform.country.options[document.editform.country.selectedIndex].text == '--SELECT--') {
    alert("Please choose your country!");
    document.editform.country.focus();
    return false;
  }
{/literal}
{/if}
{literal}
  if (document.editform.password.value != document.editform.password2.value) {
    alert("Please check your password!");
    document.editform.fullname.focus();
    return false;
  }
{/literal}
{if $settings.use_transaction_code}
{literal}
  if (document.editform.transaction_code.value != document.editform.transaction_code2.value) {
    alert("Please check your transaction code!");
    document.editform.transaction_code2.focus();
    return false;
  }
{/literal}
{/if}
{literal}
{/literal}
{if $settings.usercanchangeemail == 1}
{literal}
  if (document.editform.email.value == '') {
    alert("Please enter your e-mail address!");
    document.editform.email.focus();
    return false;
  }
{/literal}
{/if}
{literal}

  for (i in document.editform.elements) {
    f = document.editform.elements[i];
    if (f.name && f.name.match(/^pay_account/)) {
      if (f.value == '') continue;
      var notice = f.getAttribute('data-validate-notice');
      var invalid = 0;
      if (f.getAttribute('data-validate') == 'regexp') {
        var re = new RegExp(f.getAttribute('data-validate-regexp'));
        if (!f.value.match(re)) {
          invalid = 1;
        }
      } else if (f.getAttribute('data-validate') == 'email') {
        var re = /^[^\@]+\@[^\@]+\.\w{2,4}$/;
        if (!f.value.match(re)) {
          invalid = 1;
        }
      }
      if (invalid) {
        alert('Invalid account format. Expected '+notice);
        f.focus();
        return false;
      }
    }
  }

  return true;
}
</script>
{/literal}


<form action="" method=post onsubmit="return checkform()" name=editform>
<input type=hidden name=a value=edit_account>
<input type=hidden name=action value=edit_account>
<input type=hidden name=say value="">

{if $frm.say eq 'changed'}
<div class="alert alert-success">Your account data has been updated successfully.</div><br><br>
{/if}
{if $errors}
{if $errors.turing_image}<div class="error">Invalid turing image</div>{/if}
{if $errors.invalid_transaction_code}<div class="error">You have provided invalid Current Transaction Code</div>{/if}
{if $errors.tfa_code}<div class="error">Invalid 2FA code</div>{/if}
{if $errors.no_fullname}<div class="error">Please enter your full name</div>{/if}
{if $errors.ip_exists_in_database}<div class="error">Your IP already exists in our database. Sorry, but registration impossible</div>{/if}
{if $errors.invalid_username}<div class="error">Please enter valid username! It should contains English letters and digits only.</div>{/if}
{if $errors.username_too_short}<div class="error">Username should contains {$errors.username_too_short} charaters at least</div>{/if}
{if $errors.username_exists}<div class="error">The Username is already taken. Please try another Username.</div>{/if}
{if $errors.password_confirm}<div class="error">Please correcty confirm your password</div>{/if}
{if $errors.password_too_small}<div class="error">The password you provided is too small, please enter at least {$errors.password_too_small} characters!</div>{/if} 
{if $errors.invalid_email}<div class="error">Please valid email address</div>{/if} 
{if $errors.email_confirm}<div class="error">Please correcty confirm your email address</div>{/if}
{if $errors.email_exists}<div class="error">An account with this email is already exist</div>{/if}
{if $errors.no_address}<div class="error">Please enter your address</div>{/if}
{if $errors.no_city}<div class="error">Please enter your city</div>{/if}
{if $errors.no_state}<div class="error">Please enter your state</div>{/if}
{if $errors.no_zip}<div class="error">Please enter your zip</div>{/if}
{if $errors.no_country}<div class="error">Please enter your country</div>{/if}
{if $errors.transaction_code_confirm}<div class="error">Please correcty confirm your transaction code</div>{/if}
{if $errors.transaction_code_too_small}<div class="error">The transaction code you provided is too small, please enter at least {$errors.transaction_code_too_small} characters!</div>{/if} 
{if $errors.transaction_code_vs_password}<div class="error">The Transaction Code should not be equal to the Password you have defined</div>{/if}
{if $errors.invalid_account_format}
 {foreach from=$errors.invalid_account_format item=err}
 <div class="error">{$err}</div>
 {/foreach}
{/if}
{/if}
<div class="row">
<div class="col-md-4 col-xxl-3">
            <!-- Card -->
            <div class="card border-0 sticky-md-top top-10px">
                <div class="card-body">
                    <div class="text-center mb-5">
                        <div class="avatar avatar-xxl avatar-circle mb-5">

<label class="d-block cursor-pointer">
    <span class="position-absolute bottom-0 end-0 m-0 text-bg-primary w-30px h-30px rounded-circle d-flex align-items-center justify-content-center">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14" width="14">
            <g>
                <path d="M2.65,16.4a.5.5,0,0,0-.49-.13.52.52,0,0,0-.35.38L.39,23a.51.51,0,0,0,.6.6l6.36-1.42a.52.52,0,0,0,.38-.35.5.5,0,0,0-.13-.49Z" style="fill: currentColor" />
                <path d="M17.85,7.21l-11,11a.24.24,0,0,0,0,.35l1.77,1.77a.5.5,0,0,0,.71,0L20,9.68A.48.48,0,0,0,20,9L18.21,7.21A.25.25,0,0,0,17.85,7.21Z" style="fill: currentColor" />
                <path d="M16.79,5.79,15,4a.48.48,0,0,0-.7,0L3.71,14.63a.51.51,0,0,0,0,.71l1.77,1.77a.24.24,0,0,0,.35,0l11-11A.25.25,0,0,0,16.79,5.79Z" style="fill: currentColor" />
                <path d="M22.45,1.55a4,4,0,0,0-5.66,0l-.71.71a.51.51,0,0,0,0,.71l5,4.95a.52.52,0,0,0,.71,0l.71-.71A4,4,0,0,0,22.45,1.55Z" style="fill: currentColor" />
            </g>
        </svg>
    </span>
    <input type="file" wire:model='photo' class="d-none">
</label>
<img src="https://png.pngtree.com/png-vector/20220521/ourlarge/pngtree-avatar-profile-icon-png-image_4644647.png" alt="Profile picture" class="avatar-img" width="120" height="120">

</div>

<!-- Livewire Component wire-end:oKBdievsVa4zmmW7DTvd -->
</div>
<h3 class="mb-0">{$userinfo.name|escape:"quotes"}</h3>
<span class="small text-secondary fw-semibold">{$userinfo.email}</span>
</div>
<!-- Divider -->
<hr class="mb-0">


<ul class="scrollspy mb-5" id="account" >
    <li class="active">
        <a href="#basicInformationSection" class="d-flex align-items-center py-3">
            <svg viewBox="0 0 24 24" height="14" width="14" class="me-3" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.750 6.000 A5.250 5.250 0 1 0 17.250 6.000 A5.250 5.250 0 1 0 6.750 6.000 Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M2.25,23.25a9.75,9.75,0,0,1,19.5,0" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            </svg>
            Basic information
        </a>
    </li>

    <li>
        <a href="#passwordSection" class="d-flex align-items-center py-3">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" height="14" width="14" class="me-3">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.75 9.75H5.25C4.42157 9.75 3.75 10.4216 3.75 11.25V21.75C3.75 22.5784 4.42157 23.25 5.25 23.25H18.75C19.5784 23.25 20.25 22.5784 20.25 21.75V11.25C20.25 10.4216 19.5784 9.75 18.75 9.75Z" />
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6.75 9.75V6C6.75 4.60761 7.30312 3.27226 8.28769 2.28769C9.27226 1.30312 10.6076 0.75 12 0.75C13.3924 0.75 14.7277 1.30312 15.7123 2.28769C16.6969 3.27226 17.25 4.60761 17.25 6V9.75" />
                <path stroke="currentColor" stroke-width="1.5" d="M8.625 15C8.41789 15 8.25 14.8321 8.25 14.625C8.25 14.4179 8.41789 14.25 8.625 14.25" />
                <path stroke="currentColor" stroke-width="1.5" d="M8.625 15C8.83211 15 9 14.8321 9 14.625C9 14.4179 8.83211 14.25 8.625 14.25" />
                <path stroke="currentColor" stroke-width="1.5" d="M8.625 18.75C8.41789 18.75 8.25 18.5821 8.25 18.375C8.25 18.1679 8.41789 18 8.625 18" />
                <path stroke="currentColor" stroke-width="1.5" d="M8.625 18.75C8.83211 18.75 9 18.5821 9 18.375C9 18.1679 8.83211 18 8.625 18" />
                <path stroke="currentColor" stroke-width="1.5" d="M12 15C11.7929 15 11.625 14.8321 11.625 14.625C11.625 14.4179 11.7929 14.25 12 14.25" />
                <path stroke="currentColor" stroke-width="1.5" d="M12 15C12.2071 15 12.375 14.8321 12.375 14.625C12.375 14.4179 12.2071 14.25 12 14.25" />
                <g>
                    <path stroke="currentColor" stroke-width="1.5" d="M12 18.75C11.7929 18.75 11.625 18.5821 11.625 18.375C11.625 18.1679 11.7929 18 12 18" />
                    <path stroke="currentColor" stroke-width="1.5" d="M12 18.75C12.2071 18.75 12.375 18.5821 12.375 18.375C12.375 18.1679 12.2071 18 12 18" />
                </g>
                <g>
                    <path stroke="currentColor" stroke-width="1.5" d="M15.375 15C15.1679 15 15 14.8321 15 14.625C15 14.4179 15.1679 14.25 15.375 14.25" />
                    <path stroke="currentColor" stroke-width="1.5" d="M15.375 15C15.5821 15 15.75 14.8321 15.75 14.625C15.75 14.4179 15.5821 14.25 15.375 14.25" />
                </g>
                <g>
                    <path stroke="currentColor" stroke-width="1.5" d="M15.375 18.75C15.1679 18.75 15 18.5821 15 18.375C15 18.1679 15.1679 18 15.375 18" />
                    <path stroke="currentColor" stroke-width="1.5" d="M15.375 18.75C15.5821 18.75 15.75 18.5821 15.75 18.375C15.75 18.1679 15.5821 18 15.375 18" />
                </g>
            </svg>
            Password
        </a>
    </li>



    <li>
        <a href="#paymentMethodsSection" class="d-flex align-items-center py-3">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="14" width="14" class="me-3">
                <defs>
                    <style>
                        .a {
                            fill: none;
                            stroke: currentColor;
                            stroke-linecap: round;
                            stroke-linejoin: round;
                            stroke-width: 1.5px;
                        }

                    </style>
                </defs>
                <title>credit-card-1</title>
                <rect class="a" x="0.75" y="3.75" width="22.5" height="16.5" rx="1.5" ry="1.5" />
                <line class="a" x1="0.75" y1="8.25" x2="23.25" y2="8.25" />
                <line class="a" x1="5.25" y1="12.75" x2="13.5" y2="12.75" />
                <line class="a" x1="5.25" y1="15.75" x2="10.5" y2="15.75" />
            </svg>
            Payment methods
        </a>
    </li>

 
    <li>
        <a href="#privacyAndSafetySection" class="d-flex align-items-center py-3">
            <svg viewBox="0 0 24 24" height="14" width="14" class="me-3" xmlns="http://www.w3.org/2000/svg">
                <path d="M3.749,9a8.25,8.25,0,0,1,13.5-6.364" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M19.687,6a8.23,8.23,0,0,1,.562,3v6A8.25,8.25,0,0,1,12,23.25a8.336,8.336,0,0,1-1.5-.136" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M6.751,21.365a8.234,8.234,0,0,1-3-6.365V12.75" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M15.749,15V9a3.75,3.75,0,0,0-6-3" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M8.249,9v6A3.753,3.753,0,0,0,13.5,18.438" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                <path d="M11.999 9.75L11.999 14.25" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            </svg>
            Privacy and Safety
        </a>
    </li>
</ul>

</div>
</div>


<div class="col">
    <!-- Card -->
    <div class="card border-0 scroll-mt-3" id="basicInformationSection">
        <div class="card-header">
            <h2 class="h3 mb-0">Basic information</h2>
        </div>

<div class="card-body">
    <div class="row mb-4">
        <div class="col-lg-3">
            <label for="fullname" class="col-form-label">Full Name</label>
        </div>

        <div class="col-lg">
            <input type="text" class="form-control" id="fullname" name=fullname value="{$frm.fullname|default:$userinfo.name|escape:html}">
            <div class="invalid-feedback">Please add your full name</div>
        </div>
    </div> <!-- / .row -->

    <div class="row mb-4">
        <div class="col-lg-3">
            <label for="emailAddress" class="col-form-label">Email address</label>
        </div>

        <div class="col-lg">
            {if $settings.usercanchangeemail == 1}
            <input type="text" class="form-control" id="emailAddress"  name=email value="{$frm.email|default:$userinfo.email|escape:html}">
            {else}
            <input type="text" class="form-control" id="emailAddress"  name=email value="{$userinfo.email|escape:html}" readonly>
            {/if}
            <div class="invalid-feedback">Please add your email address</div>
        </div>
    </div> <!-- / .row -->

    <div class="row mb-4">
        <div class="col-lg-3">
            <label class="col-form-label">Username</label>
        </div>
        <div class="col-lg">
            <input type="text" class="form-control" value="{$userinfo.username}" readonly>
        </div>
    </div> <!-- / .row -->
    
    <div class="row mb-4">
        <div class="col-lg-3">
            <label class="col-form-label">Registration Date</label>
        </div>
        <div class="col-lg">
            <input type="text" class="form-control" value="{$userinfo.date_register}" readonly>
        </div>
    </div> <!-- / .row -->
    <div class="d-flex justify-content-end mt-5">
        <button type="submit" class="btn btn-primary">
            Save changes
        </button>
    </div>
</div>
</div>

<!-- Card -->
<div class="card border-0 scroll-mt-3" id="passwordSection">
    <div class="card-header">
        <h2 class="h3 mb-0">Password</h2>
    </div>


    <div class="card-body">

        <div class="row mb-4">
            <div class="col-lg-3">
                <label for="newPassword" class="col-form-label">New password</label>
            </div>

            <div class="col-lg">
                <div class="input-group input-group-merge">
                    <input type="password" class="form-control" name=password value="" autocomplete="off" data-toggle-password-input placeholder="Your new password">

                    <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                </div>
            </div>
        </div> <!-- / .row -->
        
        <div class="row mb-4">
            <div class="col-lg-3">
                <label for="newPassword" class="col-form-label">New password</label>
            </div>

            <div class="col-lg">
                <div class="input-group input-group-merge">
                    <input type="password" class="form-control" name=password2 value="" autocomplete="off" data-toggle-password-input placeholder="Confirm your new password">

                    <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                </div>

                <div class="invalid-feedback">Please confirm your new password again</div>
            </div>
        </div> <!-- / .row -->

        <div class="row">
            <div class="col-lg offset-lg-3">
                <div class="alert alert-light mw-450px" role="alert">
                    <h4 class="mb-3">Password requirements:</h4>
                    <ul class="p-3 mb-0">
                        <li>Minimum 8 characters long - the more, the better</li>
                        <li>At least one lowercase character</li>
                        <li>At least one uppercase character</li>
                        <li>At least one number, symbol.</li>
                    </ul>
                </div>
            </div>
        </div> <!-- / .row -->

        <div class="d-flex justify-content-end mt-5">
            <!-- Button -->
            <button type="submit" class="btn btn-primary">Save changes</button>
        </div>
        

{if $settings.use_transaction_code}
  {if $settings.use_transaction_code_edit_account != 1}
    {if $userinfo.transaction_code != ''}
    <tr>
     <td>Current Transaction Code:</td>
     <td><input type=password name=transaction_code_current value="" class=inpts size=30></td>
    </tr>
    {/if}
  {/if}
  <tr>
   <td>New Transaction Code:</td>
   <td><input type=password name=transaction_code value="" class=inpts size=30></td>
  </tr>
  <tr>
   <td>Retype Transaction Code:</td>
   <td><input type=password name=transaction_code2 value="" class=inpts size=30></td>
  </tr>
{/if}

</div>

</div>





{if $settings.use_user_location}
<tr>
 <td>Your Address:</td>
 <td><input type=text name=address value="{$frm.address|default:$userinfo.address|escape:html}" class=inpts size=30></td>
</tr>
<tr>
 <td>Your City:</td>
 <td><input type=text name=city value="{$frm.city|default:$userinfo.city|escape:html}" class=inpts size=30></td>
</tr>
<tr>
 <td>Your State:</td>
 <td><input type=text name=state value="{$frm.state|default:$userinfo.state|escape:html}" class=inpts size=30></td>
</tr>
<tr>
 <td>Your Zip:</td>
 <td><input type=text name=zip value="{$frm.zip|default:$userinfo.zip|escape:html}" class=inpts size=30></td>
</tr>
<tr>
 <td>Your Country:</td>
 <td>
  <select name=country class=inpts>
<option value="">--SELECT--</option>
{foreach from=$countries item=c}
<option {if ($frm.country && $c.name == $frm.country) || (!$frm.country && $c.name == $userinfo.country)}selected{/if}>{$c.name|escape:html}</option>
{/foreach}
  </select>
 </td>
</tr>
{/if}



<!-- Card -->
<div class="card border-0 scroll-mt-3" id="paymentMethodsSection">
    <div class="card-header">
        <h2 class="h3 mb-0">Payment methods</h2>
    </div>
    <div class="card-body">
            <div class="row">

{foreach item=ps from=$pay_accounts}
<div class="mb-3 col-md-6">
    <label class="">{$ps.name}</label>
    {if $settings.usercanchangeegoldacc == 0 && $ps.account != ''}{$ps.account|escape:html}{else}<input type=text class="form-control" name="pay_account[{$ps.id}]" value="{$frm.pay_account[$ps.id]|default:$ps.account|escape:html}" data-validate="{$ps.validate.func}" data-validate-{$ps.validate.func}="{$ps.validate[$ps.validate.func]}" data-validate-notice="{$ps.validate.notification|escape:html}" placeholder="Enter {$ps.name} Address">{/if}
    <small class="fs-6">Enter your {$ps.name} Address </small>
</div>
{/foreach}
{foreach item=p from=$mpay_accounts}
{foreach item=ps from=$p.accounts}
<div class="mb-3 col-md-6">
    <label class="">{$p.name} {$ps.name}</label>
    {if $settings.usercanchangeegoldacc == 0 && $ps.value != ''}{$ps.value|escape:html}{else}<input type=text class="form-control" name="pay_account[{$p.id}][{$ps.name|escape:html}]" value="{$frm.pay_account[$p.id][$ps.name]|default:$ps.value|escape:html}" placeholder="Enter {$p.name} {$ps.name} Address">{/if}
    <small class="fs-6">Enter your {$p.name} {$ps.name} Address </small>
</div>
{/foreach}
{/foreach}
</div>
<div class="d-flex justify-content-end mt-5">
    <button type="submit" class="btn btn-primary">
        Save changes
    </button>
</div>

</div>
</div>


{if $settings.use_rcb}
<tr>
 <td>Your RCB Percent:</td>
 <td>{if $userinfo.rcb_lock}{$userinfo.rcb}%{else}<input type=text class=inpts size=30 name="rcb" value="{$frm.rcb|default:$userinfo.rcb|number_format:2}">{/if}</td>
</tr>
{/if}
{if $userinfo.admin_auto_pay_earning == 1}
<tr>
 <td colspan=2><input type=checkbox name=user_auto_pay_earning value=1 {if $userinfo.user_auto_pay_earning == 1}checked{/if}> Receive earnings directly to e-currency account</td>
</tr>
{/if}
{if $settings.use_transaction_code_edit_account == 1}
<tr>
 <td>Current Transaction Code:</td>
 <td><input type=password name=transaction_code_current value="" class=inpts size=30></td>
</tr>
{/if}
{if $userinfo.tfa_settings.edit_account}
<tr>
 <td>2FA Code:</td>
 <td><input type="text" name="tfa_code" class=inpts size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
{include file="captcha.tpl" action="edit_account"}

<!-- Card -->
<div class="card border-0 scroll-mt-3" id="privacyAndSafetySection">
    <div class="card-header">
        <h2 class="h3 mb-0">Privacy and Safety</h2>
    </div>

    <div class="card-body">
        <ul class="list-group list-group-flush">
            <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                <div class="me-2">
                    <h3 class="h4 mb-0">Use 2-Step Verification</h3>
                </div>
                <a href="?a=security" class="btn btn-sm text-bg-info-soft border-0">View</a>
            </li>
            

            <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                <div class="me-2">
                    <h3 class="h4 mb-0">Delete Account</h3>
                </div>
                <a href="#0" class="btn btn-sm text-bg-danger-soft border-0">Delete
                    account
                </a>
            </li>
        </ul>
    </div>
</div>
</div>
</div>

</form>

</div>
{include file="footer_dash.tpl"}